{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       David Jorge Aguirre Grazio (djagra@mcrenox.com.ar).

Description:  Google API - Spelling Suggestion
              SOAP Client emulation
              using HTTP Client, for Delphi 2005.
              Try Google Search Interface
              http://www.mcrenox.com.ar/googsi

Web page:     downloads.mcrenox.com.ar

Creation:     08/18/2006

Version:      1.0

Location:     San Miguel de Tucumn - Repblica Argentina

Legal issues: Copyright (C) 2002-2006 by David Jorge Aguirre Grazio
              for Mc & RENOX technologies.

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software and
                 a copy mailed to delphi@xploiter.com.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, HttpProt, WSocket, XPMan;

type
  TMainForm = class(TForm)
    HttpCli: THttpCli;
    XPManifest1: TXPManifest;
    QueryEdit: TEdit;
    CheckBt: TSpeedButton;
    Memo: TMemo;
    Label1: TLabel;
    KeyLabel: TLabel;
    procedure KeyLabelClick(Sender: TObject);
    procedure QueryEditKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure CheckBtClick(Sender: TObject);
    procedure HttpCliBeforeHeaderSend(Sender: TObject; const Method: string; Headers: TStrings);
    procedure HttpCliRequestDone(Sender: TObject; RqType: THttpRequest; ErrCode: Word);
    procedure HttpCliDocEnd(Sender: TObject);
    procedure HttpCliDocBegin(Sender: TObject);
  private
    { Private declarations }
    GoogleKey: String;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.HttpCliBeforeHeaderSend(Sender: TObject; const Method: string; Headers: TStrings);
begin
    Headers.Clear;
    Headers.Add('POST /search/beta2 HTTP/1.0');
    Headers.Add('SOAPAction: "urn:GoogleSearchAction"');
    Headers.Add('Content-Type: text/xml');
    Headers.Add('User-Agent: Borland SOAP 1.2');
    Headers.Add('Host: api.google.com');
    Headers.Add('Content-Length: '+IntToStr(HttpCli.SendStream.Size));
    Headers.Add('Connection: Keep-Alive');
    Headers.Add('Cache-Control: no-cache');
end;

procedure TMainForm.HttpCliDocBegin(Sender: TObject);
begin
    try
       HttpCli.RcvdStream:=TMemoryStream.Create;
    except
       Exit;
       end;
end;

procedure TMainForm.HttpCliDocEnd(Sender: TObject);
begin
    if HttpCli.SendStream <> nil then
       begin
       HttpCli.SendStream.Free;
       HttpCli.SendStream:=nil;
       end;
end;

procedure TMainForm.HttpCliRequestDone(Sender: TObject; RqType: THttpRequest; ErrCode: Word);
var
   ErrorStr: String;
   ErrorCde: Integer;
   Success: Boolean;
begin
    if HttpCli.SendStream <> nil then
       begin
       HttpCli.SendStream.Free;
       HttpCli.SendStream:=nil;
       end;
    CheckBt.Enabled:=True;
    QueryEdit.Enabled:=True;

    Success:=False;
    ErrorCde:=-1;
    ErrorStr:='';
    if ErrCode = 0 then
       begin
       if (HttpCli.StatusCode >= 100) and (HttpCli.StatusCode < 300) then
          begin
          Success:=True;
          HttpCli.RcvdStream.Position:=0;
          Memo.Lines.LoadFromStream(HttpCli.RcvdStream);
          end
       else if (HttpCli.StatusCode >= 300) and (HttpCli.StatusCode < 400) then
          begin
          end
       else if (HttpCli.StatusCode >= 400) and (HttpCli.StatusCode < 500) then
          begin
          case HttpCli.StatusCode of
             400: ErrorStr:='Bad request';
             401: ErrorStr:='Not authorised';
             402: ErrorStr:='Payment required';
             403: ErrorStr:='Forbidden';
             404: ErrorStr:='Not found';
             405: ErrorStr:='Method not allowed';
             406: ErrorStr:='Not acceptable';
             407: ErrorStr:='Proxy authentication required';
             408: ErrorStr:='Request timeout';
             409: ErrorStr:='Conflict';
             410: ErrorStr:='Gone';
             411: ErrorStr:='Length required';
             412: ErrorStr:='Precondition failed';
             413: ErrorStr:='Request entity too large';
             414: ErrorStr:='Request URI too long';
             415: ErrorStr:='Unsupported media type';
             416: ErrorStr:='Requested range not satisfiable';
             417: ErrorStr:='Expectation failed';
             else ErrorStr:='';
             end;
          ErrorCde:=HttpCli.StatusCode;
          end
       else if HttpCli.StatusCode >= 500 then
          begin
          case HttpCli.StatusCode of
             500: ErrorStr:='Internal server error';
             501: ErrorStr:='Not implemented';
             502: ErrorStr:='Bad gateway';
             503: ErrorStr:='Service unavailable';
             504: ErrorStr:='Gateway timeout';
             505: ErrorStr:='HTTP version not supported';
             else ErrorStr:='';
             end;
          ErrorCde:=HttpCli.StatusCode;
          end;
       end
    else
       begin
       ErrorStr:=WSocketErrorDesc(ErrCode);
       ErrorCde:=ErrCode;
       end;

    if not Success then
       begin
       if Assigned(HttpCli.RcvdStream) then
          begin
          HttpCli.RcvdStream.Free;
          HttpCli.RcvdStream:=nil;
          end;
       MessageDlg('Error '+ErrorStr+' ('+IntToStr(ErrorCde)+')',mtError,[mbOk],0)
       end;
end;

procedure TMainForm.CheckBtClick(Sender: TObject);
var
   Data: String;
begin
    if (GoogleKey='') or (QueryEdit.Text='') then Exit;
    CheckBt.Enabled:=False;
    QueryEdit.Enabled:=False;
    Memo.Clear;
    Memo.Lines.Add(#13#10#13#10#13#10#13#10#13#10#13#10);
    Memo.Lines.Add(#9#9#9+'Please wait...');

    HttpCli.RcvdStream:=nil;
    HttpCli.Proxy:='';
    HttpCli.ProxyPort:='';
    HttpCli.ProxyUsername:='';
    HttpCli.ProxyPassword:='';
    HttpCli.URL:='http://api.google.com';
    HttpCli.Agent:='';
    HttpCli.Reference:='';
    HttpCli.Sender:='';
    HttpCli.Username:='';
    HttpCli.Password:='';
    HttpCli.ModifiedSince:=0;

    Data:='<?xml version="1.0" encoding="UTF-8"?>'+#13#10+
          '<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:xsd="http://www.w3.org/1999/XMLSchema">'+#13#10+
          '<SOAP-ENV:Body>'+#13#10+
          '<ns1:doSpellingSuggestion xmlns:ns1="urn:GoogleSearch"'+#13#10+
          'SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">'+#13#10+
          '<key xsi:type="xsd:string">'+GoogleKey+'</key>'+#13#10+
          '<phrase xsi:type="xsd:string">'+QueryEdit.Text+'</phrase>'+#13#10+
          '</ns1:doSpellingSuggestion>'+#13#10+
          '</SOAP-ENV:Body>'+#13#10+
          '</SOAP-ENV:Envelope>';

    HttpCli.SendStream := TMemoryStream.Create;
    HttpCli.SendStream.Write(Data[1], Length(Data));
    HttpCli.SendStream.Seek(0, 0);

    try
       HttpCli.PostAsync;
    except
       CheckBt.Enabled:=True;
       QueryEdit.Enabled:=True;
       Exit;
       end;
end;

procedure TMainForm.QueryEditKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
    if Key = VK_RETURN then
       if CheckBt.Enabled then
          CheckBt.Click;
end;

procedure TMainForm.KeyLabelClick(Sender: TObject);
var
   Key: String;
begin
    Key:=GoogleKey;
    if InputQuery('Google License Key','Enter your key (32 character):', Key) then
       if Length(Key) <> 32 then Key:='';
    if Key <> '' then
       begin
       GoogleKey:=Key;
       Memo.Clear;
       CheckBt.Enabled:=True;
       ActiveControl:=QueryEdit;
       end
    else
       begin
       GoogleKey:='';
       CheckBt.Enabled:=False;
       end;
end;

end.
